////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// note: The TSP100IO.dll .Net class library depends on the native dll component as follows.
//           TSP100LMIF.dll, TSP100ELMIF.dll
//       The native dll component is installed in "%Program Files%\StarMicronics\TSP100\Software\xxxxxxxx" folder.
//       Please set the installation directory of native dll component to Environment.CurrentDirectory.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
using System;
using System.IO;
using System.Collections.Generic;
using System.Text;

using StarMicronics.TSP100IO;

namespace TSP100StatusMonitorSample.CSharp
{
    class Program
    {
        static void Main(string[] args)
        {
            string rKeyName64 = @"SOFTWARE\Wow6432Node\StarMicronics\TSP100 Installer";
            string rKeyName32 = @"SOFTWARE\StarMicronics\TSP100 Installer";
            string rGetValueName = "Software Directory";

            Microsoft.Win32.RegistryKey rKey = Microsoft.Win32.Registry.LocalMachine.OpenSubKey(rKeyName64);
            if (rKey == null)
            {
                rKey = Microsoft.Win32.Registry.LocalMachine.OpenSubKey(rKeyName32);
                if (rKey == null)
                {
                    Console.WriteLine("TSP100 is not installed.");
                    return;
                }
            }

            string InstallDir = (string)rKey.GetValue(rGetValueName);
            rKey.Close();

            string dirpath = Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles);
            Environment.CurrentDirectory = dirpath + InstallDir.Substring(InstallDir.IndexOf("\\StarMicronics"));

            Console.Write("Enter the printer queue name: ");
            string portName = Console.ReadLine();

            bool run = true;
            while (run == true)
            {
                Console.WriteLine();

                Console.WriteLine("[1] Get Status");
                Console.WriteLine("[0] Exit Program");
                Console.Write("Select one of the above options: ");

                uint selection;
                try
                {
                    selection = uint.Parse(Console.ReadLine());
                }
                catch
                {
                    selection = 0;
                }

                switch (selection)
                {
                    case 1:
                        GetStatusUsage(portName);
                        break;
                    case 0:
                        run = false;
                        break;
                    default:
                        Console.WriteLine("Invalid option");
                        break;
                }
            }
        }

        private static void GetStatusUsage(string portName)
        {
            IPort port = null;
            try
            {
                port = StarMicronics.TSP100IO.Factory.I.GetPort(portName);

                StarPrinterStatus printerStatus = port.GetParsedStatus();
                if (printerStatus.Offline == false)
                {
                    Console.WriteLine("The printer is online");
                }
                else
                {
                    Console.WriteLine("The printer is offline");
                    if (printerStatus.PaperEmpty == true)
                    {
                        Console.WriteLine("\tPaper empty");
                    }

                    if (printerStatus.CoverOpen == true)
                    {
                        Console.WriteLine("\tCover open");
                    }

                }

                Console.WriteLine("Success");
            }
            catch (PortException e)
            {
                Console.WriteLine("Failure - see stack trace:\n" + e.StackTrace);
            }
            finally
            {
                if (port != null)
                {
                    StarMicronics.TSP100IO.Factory.I.ReleasePort(port);
                }
            }
        }
    }
}
