/*
  Visual Studio project setup
  ////////////////////////////
  1. Add this package's 'redistributables\include' directory to your project's 'Additional Include Directories' project property (under C/C++ -> General)
  2. Add this statement to your source code files: '#include <SMCSMicroReceipt.h>'
  3. Add this package's 'redistributables\lib' directory to your project's 'Additional Library Directories' project property (under Linker -> General)
  4. Add 'SMCSMicroReceipt.lib' to your project's 'Additional Dependencies' project property (under Linker -> Input)
*/

#pragma once

#include <windows.h>

typedef enum
{
    DISABLE = 0,                          //MicroReceipt setting is disable
    INFORMATION_WITH_QRCODE = 1,          //MicroReceipt setting is Information Logo + QR code
    ONLY_QRCODE = 2,                      //MicroReceipt setting is QR code
    ONDEMAND_INFORMATION_WITH_QRCODE = 3, //This value is for TSP100 series only. MicroReceipt setting is OnDemand with Information Logo + QR code
    ONDEMAND_ONLY_QRCODE = 4              //This value is for TSP100 series only. MicroReceipt setting is OnDemand with Only QR code
} SMCSMicroReceiptType;

typedef enum
{
    SUCCESS  = 0,                       //Completed successfully.
    SMCS_NOT_REGISTERED = 1,            //Star Cloud Services is unregistered.
    PRINTER_NAME_NOT_FOUND =2,          //Cannot find the printer name specified. Plase specify the printer queue name.
    MICRORECEIPT_PARMETER_NOT_FOUND = 3,//Cannot find the microreceipt parameter.
    SETTING_VALUE_IS_INCORRECT = 4,     //SMCSMicroReceiptType value setting is wrong. Please check the printer model.
    INITIALIZE_ERROR = 5,               //Failed to initialize.
    XML_FILE_NOT_BE_LOADED = 6,         //Failed to load the xml file.
    TIMEOUT = 7,                        //Operation timed out.
    MUTEX_ERROR = 8,                    //Failed to mutex.
    
}SMCSMicroReceiptResult;


#ifdef __cplusplus
extern "C"
{
#endif

/*
    GetMicroReceiptType
    --------
    The GetMicroReceiptType function retrieves MicroReceipt value.

    Parameters: lpPrinterName[in]   -  Please specify the device (printer queue) registered with the Star Cloud Services account.
                                       Please refer to the software manual of each utility.

                type[out]           - pointer to a SMCSMicroReceiptType enum

    Returns:    SMCSMicroReceiptResult eunm
                 If the function succeeds, the return value is SUCCESS.
                 If the function fails, the return value is not-SUCCESS.

    Notes:      Please close the Utility(TSP100 Configuration Utility or Printer Utility)
                and use this function.   
 
*/
SMCSMicroReceiptResult WINAPI GetMicroReceiptTypeW(wchar_t const *  lpPrinterName, SMCSMicroReceiptType * type);
SMCSMicroReceiptResult WINAPI GetMicroReceiptTypeA(char const *  lpPrinterName, SMCSMicroReceiptType * type);

/*
    SetMicroReceiptType
    --------
    The SetMicroReceiptType function sets MicroReceipt value.

    Parameters: lpPrinterName[in]   - Please specify the device (printer queue) registered with the Star Cloud Services account.
                                      Please refer to the software manual of each utility.

                type[in]            - Specify SMCSMicroReceiptType enum
                                      This value can be the following value.
                                         - DISABLE
                                         - INFORMATION_WITH_QRCODE
                                         - ONLY_QRCODE
                                         - ONDEMAND_INFORMATION_WITH_QRCODE
                                         - ONDEMAND_ONLY_QRCODE

    Returns:    SMCSMicroReceiptResult eunm
                 If the function succeeds, the return value is SUCCESS.
                 If the function fails, the return value is not-SUCCESS. 

    Notes:      Please close the Utility(TSP100 Configuration Utility or Printer Utility)
                and use this function.   
*/
SMCSMicroReceiptResult WINAPI SetMicroReceiptTypeW(wchar_t const *  lpPrinterName, SMCSMicroReceiptType type);
SMCSMicroReceiptResult WINAPI SetMicroReceiptTypeA(char const *  lpPrinterName, SMCSMicroReceiptType type);

#ifdef _UNICODE

 #define GetMicroReceiptType(lpPrinterName, type) GetMicroReceiptTypeW(lpPrinterName, type)
 #define SetMicroReceiptType(lpPrinterName, type) SetMicroReceiptTypeW(lpPrinterName, type)

#else

 #define GetMicroReceiptType(lpPrinterName, type) GetMicroReceiptTypeA(lpPrinterName, type)
 #define SetMicroReceiptType(lpPrinterName, type) SetMicroReceiptTypeA(lpPrinterName, type)

#endif

#ifdef __cplusplus
}
#endif